<?php
defined('PF_VERSION') OR exit('Access denied');
$current = isset($_GET['current']) ? $_GET['current'] : '';
?>
<div class="row pull-right btnTop">
    <div class="col-md-12">
        <?php
        add_toolbar_button(form_button("<i class='fa fa-check'></i> " . __('Save', 'contactform'), array('class' => 'btn btn-primary btnSave')));
        add_toolbar_button(form_button(" " . __('Cancel', 'contactform'), array('onclick' => "window.location='" . admin_url(array('admin-page' => 'contact-form', 'current' => $current), false) . "'", 'class' => 'btn btn-default')));
        ?>
    </div>
</div><!--end button-->
<div class="row">
    <div class="col-sm-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">
                    <i class="fa fa-list"></i> <?php echo __('Contact Form', 'contactform'); ?>
                </h3>
            </div>
            <div class="panel-body">
                <form action="<?php echo admin_url('&act=edit') ?>" class="form-horizontal" method="post" role="form">
                    <table class="table table-bordered form">
                        <colgroup>
                            <col span="1" class="col-md-2 header">
                            <col span="1" class="col-md-4">
                            <col span="1" class="col-md-2 header">
                            <col span="1" class="col-md-4">
                        </colgroup>
                        <tr>
                            <td>
                                <label class="control-label"><?php echo __('Title', 'contactform') ?> <span>*</span></label>
                            </td>
                            <td colspan="3" class="<?php echo state_validator('title', $validated); ?>">
                                <?php
                                echo form_input(array('name' => 'title', 'class' => 'form-control', 'tabindex' => 1, 'value' => e($contactform['title'])));
                                echo form_input(array('name' => 'current', 'type' => 'hidden', 'value' => $current));
                                echo form_input(array('name' => 'id', 'type' => 'hidden', 'value' => $id));
                                echo alert_error_validator('title', $validated);
                                ?>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label for="status" class="control-label"><?php echo __('Status', 'contactform'); ?></label>
                            </td>
                            <td colspan="3">
                                <?php
                                echo form_dropdown('status', $status, $contactform['status'], "class='form-control' tabindex='2'");
                                ?>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label class="control-label"><?php echo __('Form', 'contactform') ?> <span>*</span></label>
                            </td>
                            <td colspan="3" class="<?php echo state_validator('form', $validated); ?>">
                                <ul class="list-unstyled list-inline btnAddLists">
                                    <li title="Input text" data-toggle="tooltip">
                                        <button class="btn btn-custom-control btn-xs" type="button" data-group="Input" data-type="text" data-toggle="modal" data-target=".addItemControl">
                                            <i class="fa fa-text-width"></i>
                                        </button>
                                    </li>
                                    <li title="Email" data-toggle="tooltip">
                                        <button class="btn btn-custom-control btn-xs" type="button" data-group="Input" data-type="email" data-toggle="modal" data-target=".addItemControl">
                                            <i class="fa fa-envelope-o"></i>
                                        </button>
                                    </li>
                                    <li title="URL" data-toggle="tooltip">
                                        <button class="btn btn-custom-control btn-xs" type="button" data-group="Input" data-type="url" data-toggle="modal" data-target=".addItemControl">
                                            <i class="fa fa-link"></i>
                                        </button>
                                    </li>
                                    <li title="Number" data-toggle="tooltip">
                                        <button class="btn btn-custom-control btn-xs" type="button" data-group="Input" data-type="number" data-toggle="modal" data-target=".addItemControl">
                                            <i class="fa fa-sort-numeric-asc"></i>
                                        </button>
                                    </li>
                                    <li title="Calendar" data-toggle="tooltip">
                                        <button class="btn btn-custom-control btn-xs" type="button" data-group="Input" data-type="date" data-toggle="modal" data-target=".addItemControl">
                                            <i class="fa fa-calendar"></i>
                                        </button>
                                    </li>
                                    <li title="Textarea" data-toggle="tooltip">
                                        <button class="btn btn-custom-control btn-xs" type="button" data-group="Textarea" data-type="textarea" data-toggle="modal" data-target=".addItemControl">
                                            <i class="fa fa-file-text-o"></i>
                                        </button>
                                    </li>
                                    <li title="Checkbox" data-toggle="tooltip">
                                        <button class="btn btn-custom-control btn-xs" type="button" data-group="Select" data-type="checkbox" data-toggle="modal" data-target=".addItemControl">
                                            <i class="fa fa-check-square-o"></i>
                                        </button>
                                    </li>
                                    <li title="Radio" data-toggle="tooltip">
                                        <button class="btn btn-custom-control btn-xs" type="button" data-group="Select" data-type="radio" data-toggle="modal" data-target=".addItemControl">
                                            <i class="fa fa-check-circle-o"></i>
                                        </button>
                                    </li>
                                    <li title="Dropdown" data-toggle="tooltip">
                                        <button class="btn btn-custom-control btn-xs" type="button" data-group="Select" data-type="dropdown" data-toggle="modal" data-target=".addItemControl">
                                            <i class="fa fa-list"></i>
                                        </button>
                                    </li>
                                    <li title="Acceptance" data-toggle="tooltip">
                                        <button class="btn btn-custom-control btn-xs" type="button" data-group="Acceptance" data-type="apceectance" data-toggle="modal" data-target=".addItemControl">
                                            <i class="fa fa-legal"></i>
                                        </button>
                                    </li>
                                    <li title="Captcha" data-toggle="tooltip">
                                        <button class="btn btn-custom-control btn-xs" type="button" data-group="Captcha" data-type="captcha" data-toggle="modal" data-target=".addItemControl">
                                            <i class="fa fa-shield"></i>
                                        </button>
                                    </li>
                                    <li title="Button" data-toggle="tooltip">
                                        <button class="btn btn-custom-control btn-xs" type="button" data-group="Button" data-type="submit" data-toggle="modal" data-target=".addItemControl">
                                            <?php echo __('Button', 'contactform') ?>
                                        </button>
                                    </li>
                                </ul>
                                <?php
                                echo form_textarea(array('name' => 'form', 'class' => 'form-control', 'id' => 'form', 'tabindex' => 3), $contactform['form']);
                                echo alert_error_validator('form', $validated);
                                ?>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label class="control-label"><?php echo __('Form ID', 'contactform') ?></label>
                            </td>
                            <td class="<?php echo state_validator('form_id', $validated); ?>">
                                <?php
                                echo form_input(array('name' => 'form_id', 'class' => 'form-control', 'tabindex' => 4, 'placeholder' => __('Attribute ID', 'contactform'), 'value' => isset($contactform['form_id']) ? $contactform['form_id'] : ''));
                                echo alert_error_validator('form_id', $validated);
                                ?>
                            </td>
                            <td>
                                <label class="control-label"><?php echo __('Form Class', 'contactform') ?></label>
                            </td>
                            <td class="<?php echo state_validator('form_class', $validated); ?>">
                                <?php
                                echo form_input(array('name' => 'form_class', 'class' => 'form-control', 'tabindex' => 5, 'placeholder' => __('Attribute Class', 'contactform'), 'value' => isset($contactform['form_class']) ? $contactform['form_class'] : '' ));
                                echo alert_error_validator('form_class', $validated);
                                ?>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label class="control-label"><?php echo __('To', 'contactform') ?> <span>*</span></label>
                            </td>
                            <td class="<?php echo state_validator('to', $validated); ?>">
                                <?php
                                echo form_input(array('name' => 'to', 'class' => 'form-control', 'tabindex' => 6, 'value' => e($contactform['mail']['config']['to'])));
                                echo alert_error_validator('to', $validated);
                                ?>
                            </td>
                            <td rowspan="5">
                                <label class="control-label"><?php echo __('Message', 'contactform') ?> <span>*</span></label>
                            </td>
                            <td rowspan="5" class="<?php echo state_validator('message', $validated); ?>">
                                <?php
                                echo form_textarea(array('name' => 'message', 'class' => 'form-control', 'rows' => 12, 'tabindex' => 11), e($contactform['mail']['message']));
                                echo alert_error_validator('message', $validated);
                                ?>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label class="control-label"><?php echo __('From', 'contactform') ?> <span>*</span></label>
                            </td>
                            <td class="<?php echo state_validator('from', $validated); ?>">
                                <?php
                                echo form_input(array('name' => 'from', 'class' => 'form-control', 'tabindex' => 7, 'value' => e($contactform['mail']['config']['from'])));
                                echo alert_error_validator('from', $validated);
                                ?>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label class="control-label"><?php echo __('Name', 'contactform') ?></label>
                            </td>
                            <td class="<?php echo state_validator('name', $validated); ?>">
                                <?php
                                echo form_input(array('name' => 'name', 'class' => 'form-control', 'tabindex' => 8, 'value' => e($contactform['mail']['config']['name'])));
                                echo alert_error_validator('name', $validated);
                                ?>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label class="control-label"><?php echo __('Subject', 'contactform') ?></label>
                            </td>
                            <td class="<?php echo state_validator('subject', $validated); ?>">
                                <?php
                                echo form_input(array('name' => 'subject', 'class' => 'form-control', 'tabindex' => 9, 'value' => e($contactform['mail']['config']['subject'])));
                                ?>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label class="control-label"></label>
                            </td>
                            <td>
                                <?php
                                echo form_checkbox(array('name' => 'use_as_html', 'value' => 1, 'tabindex' => 10));
                                echo __(' Use HTML content type', 'contactform')
                                ?>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label class="control-label"><?php echo __('Sending successfully notification', 'contactform') ?></label>
                            </td>
                            <td colspan="3" class="<?php echo state_validator('notify', $validated); ?>">
                                <?php
                                echo form_textarea(array('name' => 'notify', 'class' => 'form-control', 'rows' => 3, 'tabindex' => 12), e($contactform['mail']['notify']));
                                echo alert_error_validator('notify', $validated);
                                ?>
                            </td>
                        </tr>
                    </table>
                </form>
            </div>
        </div>
    </div>
</div>
<div class="modal fade addItemControl" tabindex="-1" role="dialog" aria-labelledby="myItemControl" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-body">
                <form class="form-horizontal showItem" role="form">

                </form>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo __('Close', 'contactform'); ?></button>
                    <button type="button" class="btn btn-primary" id="btnAddItem"><?php echo __('Add', 'contactform'); ?></button>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="hidden" id="messageErrorJS">
    <ul>
        <li class="errorLengthName"><?php echo __('Name must be between 6 and 32 characters', 'contactform'); ?></li>
    </ul>
</div>
<?php
require_once ABSPATH . '/plugins/contactform/views/particals/element.php';
require_once ABSPATH . '/includes/common/plugin/views/alert.php';
 